unit HTTPClientMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, IdBaseComponent, IdComponent, IdTCPConnection,
  IdTCPClient, IdHTTP, IdIOHandler, IdIOHandlerSocket, IdIOHandlerStack,
  IdSSL, SyncObjs,
  StreamSec.Mobile.X509Comp,
  StreamSec.DSI.PkixCert, StreamSec.Mobile.TlsInternalServer,
  StreamSec.Mobile.TlsClass, SelectCipherSuitesFrame,
  smTLSId10D29IOHandler;

type
  TfrmMain = class(TForm)
    HTTP: TIdHTTP;
    Label1: TLabel;
    cbURL: TComboBox;
    btnGo: TButton;
    memHeaders: TMemo;
    memBody: TMemo;
    smSimpleTLSInternalServer1: TsmSimpleTLSInternalServer;
    smTLSIdIOHandlerSocket1: TsmTLSIdIOHandlerSocket;
    TfrmSelectCipherSuites1: TfrmSelectCipherSuites;
    procedure btnGoClick(Sender: TObject);
    procedure TLSEngineCertNotTrusted(Sender: TObject; Cert: iCertificate;
      var ExplicitTrust: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure smSimpleTLSInternalServer1TLSIncomingAlert(Sender: TObject; Client:
        TCustomTLS_ContentLayer; var Fatal: Boolean; AlertCode: Integer);
    procedure smSimpleTLSInternalServer1TLSOutgoingAlert(Sender: TObject; Client:
        TCustomTLS_ContentLayer; var Fatal: Boolean; AlertCode: Integer);
  private
    fShowCertLock: TCriticalSection;
    fCert: iCertificate;
    fExplicitTrust: Boolean;
    procedure Synchronize(AMethod: TThreadMethod);
    procedure ShowCertificate;
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

uses
  CertDialog,
  StreamSec.Mobile.TlsConst;

{$R *.dfm}

type
  TDummyThread = class(TThread);

procedure TfrmMain.btnGoClick(Sender: TObject);
var
  lURL: string;
  lSS: TStringStream;
begin
  memHeaders.Clear;
  memBody.Clear;
  if HTTP.Connected then
    HTTP.Disconnect;
  lURL := cbURL.Text;
  lSS := TStringStream.Create('');
  try
    HTTP.Get(lURL,lSS);
    lSS.Position := 0;
    memHeaders.Lines.Assign(HTTP.Response.RawHeaders);
    memBody.Lines.LoadFromStream(lSS);
    if cbURL.Items.IndexOf(lURL) < 0 then
      cbURL.Items.Add(lURL);
  finally
    lSS.Free;
  end;
end;

procedure TfrmMain.ShowCertificate;
begin
    dlgCert.Caption := 'Do you want to trust this certificate?';
    dlgCert.CertificateViewer1.Display(fCert,nil,[]);
    fExplicitTrust := dlgCert.ShowModal = mrOK;
end;

procedure TfrmMain.Synchronize(AMethod: TThreadMethod);
begin
  if GetCurrentThreadID = MainThreadID then
    AMethod
  else begin
    with TDummyThread.Create(True) do try
      Synchronize(AMethod)
    finally
      Free;
    end;
  end;
end;

procedure TfrmMain.TLSEngineCertNotTrusted(Sender: TObject;
  Cert: iCertificate; var ExplicitTrust: Boolean);
begin
  fShowCertLock.Acquire;
  try
    fCert := Cert;
    Synchronize(ShowCertificate);
    ExplicitTrust := fExplicitTrust;
  finally
    fShowCertLock.Release;
  end;
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  fShowCertLock := TCriticalSection.Create;
  TfrmSelectCipherSuites1.Options := smSimpleTLSInternalServer1.Options;
end;

procedure TfrmMain.FormDestroy(Sender: TObject);
begin
  fShowCertLock.Free;
end;

procedure TfrmMain.smSimpleTLSInternalServer1TLSIncomingAlert(Sender: TObject;
    Client: TCustomTLS_ContentLayer; var Fatal: Boolean; AlertCode: Integer);
var
  Msg: string;
begin
  if AlertCode = 0 then
    Msg := 'Incoming close notification'#13#10
  else if Fatal then
    Msg := 'Incoming fatal alert ' + IntToStr(AlertCode) + #13#10
  else
    Msg := 'Incoming warning ' + IntToStr(AlertCode) + #13#10;
  Msg := Msg + StreamSec.Mobile.TlsConst.AlertMsg(AlertCode);
  if AlertCode <> 0 then
    MessageDlg(Msg,mtWarning,[mbAbort],0)
end;

procedure TfrmMain.smSimpleTLSInternalServer1TLSOutgoingAlert(Sender: TObject;
    Client: TCustomTLS_ContentLayer; var Fatal: Boolean; AlertCode: Integer);
var
  Msg: string;
begin
  if AlertCode = 0 then
    Msg := 'Outgoing close notification'#13#10
  else if Fatal then
    Msg := 'Outgoing fatal alert ' + IntToStr(AlertCode) + #13#10
  else
    Msg := 'Outgoing warning ' + IntToStr(AlertCode) + #13#10;
  Msg := Msg + StreamSec.Mobile.TlsConst.AlertMsg(AlertCode);
  if AlertCode <> 0 then begin
    if Fatal then
      MessageDlg(Msg,mtWarning,[mbAbort],0)
    else
      Fatal := MessageDlg(Msg,mtWarning,[mbIgnore,mbAbort],0) = mrAbort;
  end;
end;

end.
